/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.common.init.ModEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BloodmoonGolemEntity
extends MonsterEntity
implements IMob {
    private int attackTimer;

    public BloodmoonGolemEntity(World world) {
        this((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.BLOODMOON_GOLEM.get()), world);
    }

    public BloodmoonGolemEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return BloodmoonGolemEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 250.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttack((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (BloodmoonGolemEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_175623_d(pos)) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    static class MeleeAttack
    extends MeleeAttackGoal {
        MeleeAttack(CreatureEntity creature, double speed, boolean longMemory) {
            super(creature, speed, longMemory);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            float f = this.field_75441_b.func_213311_cf() - 0.6f;
            return f * 2.0f * f * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

